using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        string[] first = Console.ReadLine().Split();
        int N = int.Parse(first[0]);
        int Q = int.Parse(first[1]);

        int[] a = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);
        List<int> results = new List<int>();

        const int MAX_VALUE = 1000;

        for (int qi = 0; qi < Q; qi++)
        {
            string[] query = Console.ReadLine().Split();
            int type = int.Parse(query[0]);

            if (type == 2)
            {
                int index = int.Parse(query[1]) - 1;
                int value = int.Parse(query[2]);
                a[index] = value;
            }
            else
            {
                int k = int.Parse(query[1]);

                int[] inHand = new int[MAX_VALUE + 1];
                int[] future = new int[MAX_VALUE + 1];

                for (int i = k; i < N; i++)
                {
                    future[a[i]]++;
                }

                for (int i = 0; i < k; i++)
                {
                    inHand[a[i]]++;
                }

                for (int i = k; i < N; i++)
                {
                    int card = a[i];
                    inHand[card]++;
                    future[card]--;

                    int discardValue = -1;
                    int maxLoss = -1;

                    for (int val = 1; val <= MAX_VALUE; val++)
                    {
                        if (inHand[val] > 0 && future[val] == 0)
                        {
                            int loss = val * inHand[val];
                            if (loss > maxLoss || (loss == maxLoss && val < discardValue))
                            {
                                maxLoss = loss;
                                discardValue = val;
                            }
                        }
                    }

                    if (discardValue == -1)
                    {
                        for (int val = 1; val <= MAX_VALUE; val++)
                        {
                            if (inHand[val] > 0)
                            {
                                discardValue = val;
                                break;
                            }
                        }
                    }

                    inHand[discardValue] = 0;
                }

                int sum = 0;
                for (int val = 1; val <= MAX_VALUE; val++)
                {
                    sum += val * inHand[val];
                }

                results.Add(sum);
            }
        }

        Console.WriteLine(string.Join("\n", results));
    }
}